<?php
defined('_JEXEC') or die;

return [

  'transforms' => [

    // Prevent rendering only if there is no image and placeholders are disabled.
    'render' => function ($node) {

      $p = (array) ($node->props ?? []);
      $fill = !empty($p['fill_empty']);

      if ($fill) {
        return true;
      }

      // 1) Prefer content-items children (media import)
      $children = is_array($node->children ?? null) ? $node->children : [];
      foreach ($children as $child) {
        $cp = (array) ($child->props ?? []);
        $img = $cp['image'] ?? null;

        // Extract src robustly
        $src = '';
        if (is_array($img)) {
          $src = trim((string) ($img['src'] ?? $img['path'] ?? $img[0]['src'] ?? ''));
        } elseif (is_object($img)) {
          if (isset($img->src)) $src = trim((string) $img->src);
          elseif (isset($img->path)) $src = trim((string) $img->path);
          elseif (method_exists($img, '__toString')) $src = trim((string) $img);
        } else {
          $src = is_string($img) ? trim($img) : '';
        }

        if ($src !== '') {
          return true;
        }
      }

      // 2) Fallback: legacy fields (Image 1..6)
      $imgs = [
        $p['image1'] ?? null,
        $p['image2'] ?? null,
        $p['image3'] ?? null,
        $p['image4'] ?? null,
        $p['image5'] ?? null,
        $p['image6'] ?? null,
      ];

      foreach ($imgs as $img) {
        $src = '';
        if (is_array($img)) {
          $src = trim((string) ($img['src'] ?? $img['path'] ?? $img[0]['src'] ?? ''));
        } elseif (is_object($img)) {
          if (isset($img->src)) $src = trim((string) $img->src);
          elseif (isset($img->path)) $src = trim((string) $img->path);
          elseif (method_exists($img, '__toString')) $src = trim((string) $img);
        } else {
          $src = is_string($img) ? trim($img) : '';
        }

        if ($src !== '') {
          return true;
        }
      }

      return false;
    },

  ],

];
