<?php
defined('_JEXEC') or die;

return [

    'name' => 'hpb_image_follow_path',

    'title' => 'Image Follow SVG Path',

    'group' => 'HPB Design',

    'icon' => '${url:images/icon.svg}',

    'iconSmall' => '${url:images/iconSmall.svg}',

    'defaults' => [
        'height' => 120,
        'viewbox' => '0 0 1200 120',
        'path_input' => '<path d="M0,0V60C150,0,350,120,600,60C850,0,1050,120,1200,60V0Z"/>',
        'path_mode' => 'auto',
        'show_path' => false,
        'path_fill' => 'none',
        'path_stroke' => '#141316',
        'path_stroke_width' => 2,
        'path_opacity' => 0.35,
        'img_w' => 80,
        'img_h' => 80,
        'dur' => 24,
        'delay' => 0,
        'pause_between' => 0,
        'repeat' => 'indefinite',
        'playback' => 'loop',
        'hide_return' => false,
        'start_margin_left' => 0,
        'enter_time' => 0.35,
        'fade_enable' => false,
        'fade_in' => 0.5,
        'fade_out' => 0.5,
        'direction' => 'normal',
        'rotate' => false,
        'pause_hover' => true,
        'pause_tap' => true,
        'margin_top' => 0,
        'margin_bottom' => 0,
        'margin_top_s' => 0,
        'margin_bottom_s' => 0,
        'css' => '',
    ],

    'transforms' => [

        'render' => function ($node, array $params) {

            $props = $node->props;

            // Skip rendering if no path
            $path = trim((string) ($props['path_input'] ?? ''));
            if ($path === '') {
                return false;
            }

            // Skip rendering if no image
            $img = $props['image'] ?? null;
            $src = '';
            if (is_string($img)) $src = trim($img);
            if (is_array($img)) $src = trim((string)($img['src'] ?? $img['url'] ?? $img['path'] ?? ''));
            if ($src === '') {
                return false;
            }

            return $node;
        },

    ],

];
